// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityCannon.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntityCannon.h"
#include "Level.h"
#include "Application.h"




EntityCannon::EntityCannon() :
  m_Active( false )
{

  m_Z = 0.9f;

  m_Floating = true;
  m_UsingAngle = true;

  SetRect( &m_CollisionRect, 10, 10, 43, 43 );

  SetFrame( Dobbs::ANIM_CANNON );

}



EntityCannon::~EntityCannon() 
{
}



void EntityCannon::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_INIT:
      if ( m_ExtraData2 == 1 )
      {
        // fixed to current direction
      }
      else if ( m_ExtraData2 == 2 )
      {
        // rotating CW with speed extradata
      }
      else if ( m_ExtraData2 == 3 )
      {
        // rotating CCW with speed extradata
      }
      m_IntegerAngle = (int)m_Angle;
      break;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



void EntityCannon::UpdateTimed( Level& aLevel, float ElapsedTime )
{

  Entity::UpdateTimed( aLevel, ElapsedTime );

  if ( m_ExtraData2 == 2 )
  {
    m_Angle += m_ExtraData * ElapsedTime;
  }
  else if ( m_ExtraData2 == 3 )
  {
    m_Angle -= m_ExtraData * ElapsedTime;
  }
  else if ( m_ExtraData2 == 4 )
  {
    // CW in 45 degree steps
    while ( m_StateTime >= 0.5f )
    {
      m_StateTime -= 0.5f;
      m_IntegerAngle = ( m_IntegerAngle + 45 ) % 360;
    }
    m_Angle = (float)m_IntegerAngle;
  }
  else if ( m_ExtraData2 == 5 )
  {
    // CCW in 45 degree steps
    while ( m_StateTime >= 0.5f )
    {
      m_StateTime -= 0.5f;
      m_IntegerAngle = ( m_IntegerAngle + 360 - 45 ) % 360;
    }
    m_Angle = (float)m_IntegerAngle;
  }

}